from tensorflow import keras
import tensorflow as tf

import pandas as pd
import matplotlib.pyplot as plt
plt.rcParams.update({'font.size': 12})

import numpy as np
from sklearn.model_selection import train_test_split
from sklearn.metrics import confusion_matrix
from sklearn.preprocessing import StandardScaler,LabelEncoder
import tensorflow.keras
from keras.utils import np_utils
from CNNmodels import *
from confusion_matrix_2 import *



reconstructed_model = keras.models.load_model(r"../models/checkpoint_60dB_CNN_A")
os.chdir(r'./Different SNR LEVELS/CNN/best 60dB/A')

df=pd.read_csv(r"../data set/40dB_final_data.csv")
df=df.drop(columns= 'Unnamed: 0')
labelencoder = LabelEncoder()
df['Labels'] = labelencoder.fit_transform(df['damage'])
labels=df["Labels"]
dummy_labels = np_utils.to_categorical(labels)
y=dummy_labels
features = df.iloc[:,2:-1]
X=features
X_train_full, X_test_full, y_train, y_test = train_test_split(X, y, test_size=0.2, shuffle=True)
scaler = StandardScaler()
X_train = scaler.fit_transform(X_train_full)
mean_value=scaler.mean_
std_dev_value=scaler.scale_
# print(f"Training set normalization parameters\nMean values:\n{mean_value}\nStd Dev values:\n{std_dev_value}")
X_test = scaler.transform(X_test_full)
#  To save the Scaler model to use later

model = reconstructed_model
y_pred = model.predict(X_test)
# y_pred=(y_pred >0.5)
y_pred=(y_pred == y_pred.max(axis = 1)[: , None]).astype(int)
y_true=y_test


plot_confusion()